<?php

/**
* description
*
* @library	
* @author	
* @since	
*/
class CConfig {
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function newInstance($file , $type = "file" , $debug = false) {

		return new self($file , $type ,  $debug = false);
	}
	
	function __construct($file ,$type = "file" , $debug = false) {

		$lowtags = true;

		$found = false;
		$cache = false;
		clearstatcache();

		if ($type == "string") {
			$content = $file;
		} else {		
 			if ((file_exists($file) && is_file($file)) || stristr($file , "://")) {
				$content = GetFileContents($file);

				$this->__file = $file;
			} else  {
				return false;
			}
		}


		//debug($file);

		if (!trim($content)) {
		}
		
		//fix tons of & i have in xmls 
		$content = preg_replace('/<\?\s*xml([^\s]*)\?>/' , '', $content);
		

		$xml = simplexml_load_string(str_replace("&" , "[amp]" , $content));



		$this->vars = $this->__startArray($xml , $lowtags , $debug);
	}

	function __xml2array($xml , $low = false , $debug , $level = 0){
		$arr = array();



		foreach ($xml->children() as $r){
			$t = array();

			$name = $r->getName();

			if ($low) {
				$name = strtolower($name);

				//check if the name attribute exists
				if ($r->attributes()->name) {
					//debug($r->attributes()->name);
					$name = strval($r->attributes()->name);
				}					

			}
			

			//daca nu am copii
			if (count($r->children()) == 0) {

				$tmp = array();

				//cauta dupa atribute si fa parintele array
				if (count($r->attributes())) {

					if ((count($r->attributes()) == 1) && $r->attributes()->name) {
						$arr[$name] = strval($r);

						//debug($r);
					} else {				

						foreach ($r->attributes() as $_k => $_v) {
							$tmp[$_k] = strval($_v);
							
						}	
						
						if (!$arr[$name]) {
							$arr[$name] = $tmp;
						} else {
							if ($arr[$name] && !$arr[$name][0]) {
								$arr[$name] = array(
									0	=> $arr[$name]
								);
							}
							
							$arr[$name][] = $tmp;														
							
						}						
												
					}






				} else {					

					//no atribute seteaza baloarea implicit						

					if (!$arr[$name]) {
						$arr[$name] = strval($r);
					} else {					

						if (!is_array($arr[$name])) {

							$arr[$name] = array(
								0	=> $arr[$name]
							);
						} 

						$arr[$name][] = strval($r);

					}
					
					
				}
			} else {

				$tmp = $this->__xml2array($r , $low , $debug , $level+1);

				if (count($r->attributes())) {
					foreach ($r->attributes() as $_k => $_v) {

						//if field was set by kids then ignore it.
						if (!$tmp[$_k]) {
							$tmp[$_k]= strval($_v);
						}						
					}												
				}				



				$arr[$name][] = $tmp;
				//$k = key($arr[$name]);

			} 

		}

		return $arr;
	}

	 

	 function __regularize($arr) {
		if (is_array($arr) && (count($arr) == 1) && is_array($arr[0]) ) {

			if (is_array($arr[0])) {
				foreach ($arr[0] as $key => $val) {
					$arr[0][$key] = $this->__regularize($val);
				}					
			}
			
			return $arr[0];
		} else {

			if (is_array($arr)) {
				foreach ($arr as $key => $val) {
					$arr[$key] = $this->__regularize($val);
				}				
			}
			
		}
	


		return $arr;

	 }
	 


	
	 function __startArray($xml , $low = true , $debug) {

		if (!is_object($xml)) {
			trigger_error(
				"CConfig::_invalid object: 
					<ul>
						<li> - file: {$this->__file}</li>
					</ul>
				",
				E_USER_ERROR
			);
		}
		
		$arr[$low ? strtolower($xml->getName()) : $xml->getName()] = $this->__xml2array($xml , $low , $debug);

		//apped extra attributes that are aplied reictly on first tag
		if (count($xml->attributes())) {
			foreach ($xml->attributes() as $_k => $_v) {
				$arr[$xml->getName()][$_k]= strval($_v);
			}												
		} 


		//regularize array
						

		$arr = $this->__regularize($arr);	

		//fix  the [amp]
		$arr = ArrayReplace(
				"[amp]" , 
				"&" , 
				$arr
			);	

		
		return $arr;
	 }	


}


//$data = new CConfig("site.xml");


?>